﻿using log4net;
using System;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.IWS.MappingService.Interface;
using VA.PPMS.IWS.MappingService.Mappers;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService
{
    public class MappingService : IMappingService
    {
        private readonly ILog _logger;
        private readonly MapProviderToCrm _providerMapper;

        public MappingService(ILog logger, MapProviderToCrm providerMapper)
        {
            _logger = logger;
            _providerMapper = providerMapper;
        }

        public async Task<MapperResult> MapAsync(Providers providers)
        {
            try
            {
                return await MapProviderToAccount(providers);
            }
            catch (Exception ex)
            {
                _logger.Error($"@@@@ ERROR - MappingService.MapAsnc: There was a problem Mapping Add/Update Providers @@@@", ex);
                throw;
            }
        }
        
        private async Task<MapperResult> MapProviderToAccount(Providers providers)
        {
            if (providers.Provider.Count < 1) return new MapperResult();

            var results = new MapperResult();

            await _providerMapper.ResetPpmsReferences();

            foreach (var provider in providers.Provider)
            {
                try
                {
                    results.Add(await _providerMapper.Map(provider, providers.NetworkId, providers.IsVaNetwork, providers.OwnerId));
                }
                catch (Exception ex)
                {
                    results.Add(new MapperResultDetail { SchemaId = provider.ProviderId, ValidationMessage = ex.Message });
                }
            }

            return results;
        }
    }
}